/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.configuration;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.blocks.tileentity.configuration.CachedPipeConfiguration;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class FilterCache
extends CachedPipeConfiguration<List<Filter<?>>> {
    protected Function<PipeType<?>, Filter<?>> filterCreator;

    public FilterCache(Supplier<NonNullList<ItemStack>> upgradeInventory, Function<PipeType<?>, Filter<?>> filterCreator, Runnable onDirty) {
        super(upgradeInventory, "Filters", pipeType -> new ArrayList(), onDirty);
        this.filterCreator = filterCreator;
    }

    @Override
    public Tag serialize(List<Filter<?>> filters) {
        ListTag list = new ListTag();
        for (Filter<?> filter : filters) {
            list.add((Object)filter.serializeNBT());
        }
        return list;
    }

    @Override
    @Nullable
    public List<Filter<?>> deserialize(PipeType<?> pipeType, Tag inbt) {
        if (inbt instanceof ListTag) {
            ListTag list = (ListTag)inbt;
            ArrayList filters = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                Filter<?> filter = this.filterCreator.apply(pipeType);
                filter.deserializeNBT(list.m_128728_(i));
                filters.add(filter);
            }
            return filters;
        }
        return null;
    }
}

